/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.adventurez.entity.BlazeGuardianEntity;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class PiglinBeastEntity
extends Monster {
    public static final EntityDataAccessor<Float> ATTACK_TICK_VISUAL = SynchedEntityData.m_135353_(PiglinBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> LEAD_ARM = SynchedEntityData.m_135353_(PiglinBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float attackTick;
    public float armTick;
    private int makePiglinsAngry = 0;

    public PiglinBeastEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.f_21364_ = 30;
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
    }

    public static AttributeSupplier.Builder createPiglinBeastAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.225).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22281_, 9.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22277_, 38.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, BlazeGuardianEntity.class, true));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Piglin.class}));
    }

    public void m_8024_() {
        if (this.attackTick > 0.0f) {
            this.attackTick -= 0.08f;
            this.f_19804_.m_135381_(ATTACK_TICK_VISUAL, (Object)Float.valueOf(this.attackTick));
        }
        if (this.m_5448_() instanceof Player) {
            ++this.makePiglinsAngry;
            if (this.makePiglinsAngry == 600) {
                this.f_19804_.m_135381_(LEAD_ARM, (Object)Float.valueOf(1.0f));
                this.getPiglins();
                this.m_9236_().m_6269_(null, (Entity)this, SoundInit.PIGLINBEAST_SHOUT_EVENT, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
            }
            if (this.makePiglinsAngry > 600) {
                this.f_19804_.m_135381_(LEAD_ARM, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(LEAD_ARM)).floatValue() - 0.02f));
            }
            if (this.makePiglinsAngry == 650) {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.23);
                this.makePiglinsAngry = 0;
            }
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("AttackTick", this.attackTick);
        tag.m_128350_("LeadArm", 0.0f);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.attackTick = tag.m_128457_("AttackTick");
        this.armTick = tag.m_128457_("LeadArm");
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TICK_VISUAL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LEAD_ARM, (Object)Float.valueOf(0.0f));
    }

    public boolean m_6914_(LevelReader world) {
        return !world.m_46855_(this.m_20191_());
    }

    public boolean m_6785_(double num) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public boolean m_6072_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundInit.PIGLINBEAST_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.PIGLINBEAST_HURT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.PIGLINBEAST_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundInit.PIGLINBEAST_WALK_EVENT, 0.5f, 1.0f);
    }

    public void getPiglins() {
        List list = this.m_9236_().m_6443_(Piglin.class, this.m_20191_().m_82400_(40.0), EntitySelector.f_20408_);
        for (int i = 0; i < list.size(); ++i) {
            PiglinBeastEntity.angerNearbyPiglins((AbstractPiglin)list.get(i));
        }
    }

    private static void angerNearbyPiglins(AbstractPiglin piglin) {
        PiglinBeastEntity.getNearbyPiglins(piglin).forEach(abstractPiglinEntity -> PiglinBeastEntity.getNearestDetectedPlayer(abstractPiglinEntity).ifPresent(playerEntity -> PiglinBeastEntity.becomeAngryWith(abstractPiglinEntity, (LivingEntity)playerEntity)));
    }

    public static Optional<Player> getNearestDetectedPlayer(AbstractPiglin piglin) {
        return piglin.m_6274_().m_21874_(MemoryModuleType.f_148206_) ? piglin.m_6274_().m_257414_(MemoryModuleType.f_148206_) : Optional.empty();
    }

    public static void becomeAngryWith(AbstractPiglin piglin, LivingEntity target) {
        piglin.m_6274_().m_21936_(MemoryModuleType.f_26326_);
        piglin.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)target.m_20148_(), 600L);
        if (target.m_6095_() == EntityType.f_20532_ && piglin.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
            piglin.m_6274_().m_21882_(MemoryModuleType.f_26335_, (Object)true, 600L);
        }
        if (!piglin.m_9236_().m_5776_()) {
            piglin.m_21051_(Attributes.f_22281_).m_22100_(piglin.m_21133_(Attributes.f_22281_) + 3.0);
            piglin.m_5634_(piglin.m_21233_());
        }
    }

    private static List<AbstractPiglin> getNearbyPiglins(AbstractPiglin piglin) {
        return (List)piglin.m_6274_().m_257414_(MemoryModuleType.f_26346_).orElse(ImmutableList.of());
    }

    private class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((PathfinderMob)PiglinBeastEntity.this, 1.0, true);
        }

        public double m_6639_(LivingEntity entity) {
            float f = PiglinBeastEntity.this.m_20205_();
            return (double)(f * f) * 1.3 + (double)entity.m_20205_();
        }

        protected void m_6739_(LivingEntity target, double squaredDistance) {
            double number = this.m_6639_(target);
            if (squaredDistance <= number && PiglinBeastEntity.this.attackTick <= 0.0f) {
                this.f_25540_.m_9236_().m_6269_(null, (Entity)PiglinBeastEntity.this, SoundInit.PIGLINBEAST_CLUBSWING_EVENT, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)target);
                PiglinBeastEntity.this.attackTick = 1.0f;
            }
        }
    }
}

